
*## Policy scenario simulation of recursively-dynamic CGE model (over policy simulation period 2021-2040 (ts))

*###############################################################################
*########## Policy Simulation Dynamic CGE (cdyncge) simulation program #########
*###############################################################################

*Tab for Scenario 1 (Disease Burden)
*NB: Decomposition requires adjustment below:
*(1) TOTBURDENcost01, (2) TOTBURDENisolat01, (3) TOTBURDENmort01
TAB_Scen01=0;

*Tab for Scenario 2 (Improved treatment (pan-TB) - success rate 95%)
TAB_Scen02=0;

*Tab for Scenario 2_1 (NTEPI Target for Improvements in existing treatment implementation (Scaling Existing Treatment) - adjusted treatment succes rate 91.5% based on NSP strategy doc)
TAB_Scen02_1=0;

*Tab for Scenario 3 (Improved diagnosis (case detection))
TAB_Scen03=0;

*##Policy parameters

*1. Treatment regimen unit cost for DS-TB
TBTREATunitcost(DSMDRset) = DSMDR_data(DSMDRset,'COSTregimen');
TBTREATcover(DSMDRset)   = 1;
TBTREAT01('DS')          = 1;
TBTREAT01('MDR')         = 1;

*2. Isolation period (4-12 weeks)
TBISOLATperiod(DSMDRset) = DSMDR_data(DSMDRset,'DURregimen');
TBISOLATadhere(DSMDRset) = 1;
TBISOLAT01('DS')         = 1;
TBISOLAT01('MDR')        = 1;

*3. Excess TM mortality impacts on demographics and economics
TBMORT01       = 1;

*TOTAL DISEASE BURDEN ASSESSMENT
TOTBURDENcost01   = 1;
TOTBURDENisolat01 = 1;
TOTBURDENmort01   = 1;

TOTBURDENhosp01   = 0;

$libinclude xlimport CTARGETS counterfactual.xlsx CTARGETS
$libinclude xlimport CQHnut_scale counterfactual.xlsx CQHnut_scale
$libinclude xlimport CCLINOUToutput results.xlsx CCLINOUToutput

*Use GDP deflator as price numeraire (it will be allowed to vary to target nominal GDP below)
 GDPDEF.FX = GDPDEF.L;
 CPI.LO = -inf;
 CPI.UP = +inf;
* CPI.FX = CPI.L;
* GDPDEF.LO = -inf;
* GDPDEF.UP = +inf;

loop(t1$ts(t1),

*In counterfactual: Use balanced macro closure, i.e. constant government consumption share of total absorption
*In simulation: Use counterfactual growth path of government demand (GDN)
*NB: GOVSHR.L refers to the govt consumption share of absorption in the model solution for 2010 (tp07) in presim.gms
 GOVSHR.LO = -inf;
 GOVSHR.UP = +inf;
 GADJ.FX   = CTARGETS('GADJ',t1) ;
* GADJ.LO     = -inf;
* GADJ.UP     = +inf;
* GOVSHR.FX   = GOVSHR0 ;
* GDN.FX      = CTARGETS('GDN',t1) ;

 QHnut_cap_day_scale.FX(H) = CQHnut_scale(H,t1);
 QHnut_cap_day_final.LO(H) = -inf;
 QHnut_cap_day_final.UP(H) = +inf;

IF(ord(t1) gt card(tp),
*Use final week solution from previous year as initial week value for new year
S_TB.FX(h,t1_tb)$(ord(t1_tb) eq 1) = SUM(t1_tbp$(ord(t1_tbp) eq card(t1_tbpp)),S_TB.L(h,t1_tbp)) ;
L_TB.FX(h,t1_tb)$(ord(t1_tb) eq 1) = SUM(t1_tbp$(ord(t1_tbp) eq card(t1_tbpp)),L_TB.L(h,t1_tbp)) ;
I_TB.FX(h,t1_tb)$(ord(t1_tb) eq 1) = SUM(t1_tbp$(ord(t1_tbp) eq card(t1_tbpp)),I_TB.L(h,t1_tbp)) ;
Ir_TB.FX(h,t1_tb)$(ord(t1_tb) eq 1) = SUM(t1_tbp$(ord(t1_tbp) eq card(t1_tbpp)),Ir_TB.L(h,t1_tbp)) ;
T_TB.FX(h,t1_tb)$(ord(t1_tb) eq 1) = SUM(t1_tbp$(ord(t1_tbp) eq card(t1_tbpp)),T_TB.L(h,t1_tbp)) ;
Tr_TB.FX(h,t1_tb)$(ord(t1_tb) eq 1) = SUM(t1_tbp$(ord(t1_tbp) eq card(t1_tbpp)),Tr_TB.L(h,t1_tbp)) ;

*In counterfactual: Fix Nominal GDP + release GDP deflator (price numeraire)
*In simulation: Release Nominal GDP + fix GDP deflator (price numeraire)
* GDPDEF.LO = -inf;
* GDPDEF.UP = +inf;
* NGDP.FX   = TARGETS_SIM('NGDP',t1) ;
 GDPDEF.FX = CTARGETS('GDPDEF',t1) ;
 NGDP.LO = -inf;
 NGDP.UP = +inf;

*In counterfactual: Fix Real GDP growth path + release (avg.) Total Factor Productivity parameter
*In simulation: Release Real GDP + fix (avg.) Total Factor Productivity parameter growth
* TFPadj.LO = -inf;
* TFPadj.UP = +inf;
* RGDP.FX = TARGETS_SIM('RGDP',t1) ;
 TFPadj.FX = CTARGETS('TFPadj',t1);
 RGDP.LO = -inf;
 RGDP.UP = +inf;

);

*In counterfactual: Do not use revenue-neutral government budget closure
*In simulation: Use revenue-neutral government budget closure
 YG.FX = CTARGETS('YG',t1) ;
 DTINS.LO = -inf;
 DTINS.UP = +inf;


*Scenario 2
IF(TAB_Scen02 eq 1,
tau_TB(h) = 0.95
);

*Scenario 2_1
IF(TAB_Scen02_1 eq 1,
tau_TB(h) = 0.915
);

*Scenario 3
IF(TAB_Scen03 eq 1,
d_TB(h) = 0.0560632416869813
);

*Solve statement
OPTIONS ITERLIM = 5000, MCP=PATHC, DNLP=CONOPT3 ;


*Impose change in health system costs on government current expenditure
IF((ord(t1) gt card(tp)),
qbarg('c029') = qbarg0('c029') + (SUM(DSMDRset,TBTREAT01(DSMDRset)*TBTREATcover(DSMDRset)*TBTREATunitcost(DSMDRset)*DSMDRshr(DSMDRset))*SUM((h,gen,age5),(1-TAB_Scen01*TOTBURDENcost01)*CLINOUToutput(h,'INCID',gen,age5,t1-1)-CCLINOUToutput(h,'INCID',gen,age5,t1-1))/CTARGETS('GADJ',t1))*(POPscale/TARGETscale);
);


 SOLVE STANDCGE_TB USING MCP ;


*Calculate change in low BMI risk factor
RISKfact_prev.FX('r03',h) = SUM(PersonID$(((DHSdata0(h,PersonID,'Weight')+(365*(QHnut_cap_day_final.L(H)-QHnut_cap_day_final0(H))/7715))/POWER(DHSdata0(h,PersonID,'Height')/100,2))<18.5),1)/card(PersonID);


display 'here is walras', WALRAS.L;

*Retain time-specific output variables in output parameters + calculate demographic module impacts (modDEMOG_sim.inc)
$include output_cal_s.inc
$batinclude modDEMOG_sim.inc
$include output_s.inc

IF(ORD(t1) lt CARD(t1p),
 QFH.FX(h,flnd) = QFH0(h,flnd);
 QFH.FX(h,flab) = SKLshr0(h,flab)*SUM((gen,age5),part_rate(gen,age5)*(POP(h,gen,age5,t1+1)-(SUM(DSMDRset,TBISOLAT01(DSMDRset)*TBISOLATadhere(DSMDRset)*TBISOLATperiod(DSMDRset)*DSMDRshr(DSMDRset)))*((1-TAB_Scen01*TOTBURDENisolat01)*CLINOUToutput(h,'INCID',gen,age5,t1)-CCLINOUToutput(h,'INCID',gen,age5,t1))));
 QFH.FX(insd,fcap) = QFH.L(insd,fcap)*(1-DPR) + QFHshr(insd,fcap)*(SUM(C, PQ.L(C)*QINV.L(C))/IPI.L)/INVscale;
);

Display 'here is QFS', QFS.L, QFH.L;

);

$include sresults_s_t.inc

$batinclude sexport_s_t.inc 'results.xlsx'

Display RGDP.L, NGDP.L, GDPDEF.L;

